<?php
/**
 * My Licenses Template
 */

if (empty($licenses)) {
    echo '<p>' . __('You don\'t have any licenses yet.', 'licenzer') . '</p>';
    return;
}
?>

<div class="licenzer-my-licenses">
    <h2><?php _e('My Licenses', 'licenzer'); ?></h2>
    
    <table class="licenzer-licenses-table">
        <thead>
            <tr>
                <th><?php _e('License Key', 'licenzer'); ?></th>
                <th><?php _e('IP Address', 'licenzer'); ?></th>
                <th><?php _e('Software', 'licenzer'); ?></th>
                <th><?php _e('Status', 'licenzer'); ?></th>
                <th><?php _e('Expiry Date', 'licenzer'); ?></th>
                <th><?php _e('Actions', 'licenzer'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($licenses as $license): ?>
            <tr>
                <td><code><?php echo esc_html($license->license_key); ?></code></td>
                <td><?php echo esc_html($license->ip_address); ?></td>
                <td><?php echo esc_html($license->software_name); ?></td>
                <td>
                    <span class="licenzer-status licenzer-status-<?php echo $license->status ? 'active' : 'inactive'; ?>">
                        <?php echo $license->status ? __('Active', 'licenzer') : __('Inactive', 'licenzer'); ?>
                    </span>
                </td>
                <td><?php echo esc_html($license->expiry_date); ?></td>
                <td>
                    <?php if (get_option('licenzer_allow_ip_change') == 'yes'): ?>
                        <a href="#" class="licenzer-change-ip-link" data-license-key="<?php echo esc_attr($license->license_key); ?>">
                            <?php _e('Change IP', 'licenzer'); ?>
                        </a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

