<?php
/**
 * The admin-specific functionality of the plugin.
 */
class Licenzer_Admin {

    /**
     * The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     */
    public function __construct($plugin_name, $version) {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    /**
     * Register the stylesheets for the admin area.
     */
    public function enqueue_styles() {
        wp_enqueue_style(
            $this->plugin_name,
            plugin_dir_url(__FILE__) . 'css/licenzer-admin.css',
            array(),
            $this->version,
            'all'
        );
    }

    /**
     * Register the JavaScript for the admin area.
     */
    public function enqueue_scripts() {
        wp_enqueue_script(
            $this->plugin_name,
            plugin_dir_url(__FILE__) . 'js/licenzer-admin.js',
            array('jquery'),
            $this->version,
            false
        );

        wp_localize_script($this->plugin_name, 'licenzerAjax', array(
            'ajaxurl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('licenzer_nonce'),
        ));
    }

    /**
     * Register the administration menu for this plugin.
     */
    public function add_admin_menu() {
        add_menu_page(
            __('LicenZer License Manager', 'licenzer'),
            __('LicenZer', 'licenzer'),
            'manage_options',
            'licenzer',
            array($this, 'display_dashboard'),
            'dashicons-admin-network',
            30
        );

        add_submenu_page(
            'licenzer',
            __('Dashboard', 'licenzer'),
            __('Dashboard', 'licenzer'),
            'manage_options',
            'licenzer',
            array($this, 'display_dashboard')
        );

        add_submenu_page(
            'licenzer',
            __('All Licenses', 'licenzer'),
            __('All Licenses', 'licenzer'),
            'manage_options',
            'licenzer-licenses',
            array($this, 'display_licenses')
        );

        add_submenu_page(
            'licenzer',
            __('Discount Licenses', 'licenzer'),
            __('Discount Licenses', 'licenzer'),
            'manage_options',
            'licenzer-discount',
            array($this, 'display_discount')
        );

        add_submenu_page(
            'licenzer',
            __('Settings', 'licenzer'),
            __('Settings', 'licenzer'),
            'manage_options',
            'licenzer-settings',
            array($this, 'display_settings')
        );
    }

    /**
     * Register settings
     */
    public function register_settings() {
        register_setting('licenzer_settings', 'licenzer_api_url');
        register_setting('licenzer_settings', 'licenzer_reseller_token');
        register_setting('licenzer_settings', 'licenzer_allow_ip_change');
        register_setting('licenzer_settings', 'licenzer_max_ip_changes');
        register_setting('licenzer_settings', 'licenzer_enable_discount');
    }

    /**
     * Display dashboard page
     */
    public function display_dashboard() {
        require_once plugin_dir_path(__FILE__) . 'partials/licenzer-admin-dashboard.php';
    }

    /**
     * Display licenses page
     */
    public function display_licenses() {
        require_once plugin_dir_path(__FILE__) . 'partials/licenzer-admin-licenses.php';
    }

    /**
     * Display discount licenses page
     */
    public function display_discount() {
        require_once plugin_dir_path(__FILE__) . 'partials/licenzer-admin-discount.php';
    }

    /**
     * Display settings page
     */
    public function display_settings() {
        require_once plugin_dir_path(__FILE__) . 'partials/licenzer-admin-settings.php';
    }
}

