<div class="row">
    <div class="col-md-12">
        {if $error}
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle"></i> {$error}
            </div>
        {else}
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">
                        <i class="fas fa-key"></i> License Information
                    </h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th>License Key:</th>
                                    <td><code>{$license_key}</code></td>
                                </tr>
                                <tr>
                                    <th>IP Address:</th>
                                    <td>{$ip}</td>
                                </tr>
                                <tr>
                                    <th>Status:</th>
                                    <td>
                                        {if $status}
                                            <span class="label label-success">Active</span>
                                        {else}
                                            <span class="label label-danger">Inactive</span>
                                        {/if}
                                    </td>
                                </tr>
                                <tr>
                                    <th>Expiry Date:</th>
                                    <td>{$expiry_date}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h4>Installation Command</h4>
                            <div class="well">
                                <pre style="background: #f5f5f5; padding: 15px; border-radius: 4px; overflow-x: auto;">{$install_command}</pre>
                                <button class="btn btn-sm btn-primary" onclick="copyToClipboard('{$install_command|escape:"javascript"}')">
                                    <i class="fas fa-copy"></i> Copy Command
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    {if $success}
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle"></i> {$success}
                        </div>
                    {/if}
                    
                    {if $allow_ip_change && $can_change_ip}
                        <div class="row">
                            <div class="col-md-12">
                                <hr>
                                <h4>Change IP Address</h4>
                                <form method="post" action="clientarea.php?action=productdetails&id={$serviceid}&modop=custom&a=changeip">
                                    <input type="hidden" name="changeip" value="1">
                                    <input type="hidden" name="serviceid" value="{$serviceid}">
                                    <div class="form-group">
                                        <label>Current IP Address:</label>
                                        <input type="text" class="form-control" value="{$ip}" readonly>
                                    </div>
                                    <div class="form-group">
                                        <label>New IP Address:</label>
                                        <input type="text" name="new_ip" class="form-control" required pattern="^([0-9]{1,3}\.){3}[0-9]{1,3}$" placeholder="192.168.1.1">
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-exchange-alt"></i> Change IP
                                        </button>
                                    </div>
                                    {if $max_ip_changes > 0}
                                        <p class="text-muted">
                                            <small>IP Changes Remaining: {($max_ip_changes - $ip_changes)} / {$max_ip_changes}</small>
                                        </p>
                                    {else}
                                        <p class="text-muted">
                                            <small>Unlimited IP changes allowed</small>
                                        </p>
                                    {/if}
                                </form>
                            </div>
                        </div>
                    {elseif $allow_ip_change && !$can_change_ip}
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i> 
                            You have reached the maximum number of IP changes allowed.
                        </div>
                    {/if}
                </div>
            </div>
        {/if}
    </div>
</div>

<script>
function copyToClipboard(text) {
    var textarea = document.createElement('textarea');
    textarea.value = text;
    textarea.style.position = 'fixed';
    textarea.style.opacity = '0';
    document.body.appendChild(textarea);
    textarea.select();
    try {
        document.execCommand('copy');
        alert('Command copied to clipboard!');
    } catch (err) {
        alert('Failed to copy command');
    }
    document.body.removeChild(textarea);
}
</script>

