# راهنمای نصب ماژول LicenZer برای WHMCS

## پیش‌نیازها

- WHMCS نسخه 7.0 یا بالاتر
- PHP 7.2 یا بالاتر
- دسترسی به API سیستم LicenZer
- توکن نمایندگی معتبر

## ساختار ماژول

ماژول LicenZer شامل دو بخش است:

1. **Server Module** - برای مدیریت سرویس‌ها و بخش کلاینت
2. **Addon Module** - برای مدیریت ادمین و قابلیت‌های پیشرفته

## مراحل نصب

### 1. نصب Server Module

#### آپلود فایل‌ها

فایل‌های Server Module را در مسیر زیر کپی کنید:
```
modules/servers/licenzer/
```

#### فعال‌سازی ماژول

1. وارد پنل ادمین WHMCS شوید
2. به بخش **Setup > Products/Services > Servers** بروید
3. روی **Add New Server** کلیک کنید
4. نوع سرور را **LicenZer License Manager** انتخاب کنید

### 3. تنظیمات نصب کننده

بعد از انتخاب ماژول، صفحه نصب کننده نمایش داده می‌شود:

#### تنظیمات مورد نیاز:

1. **Reseller Token** (الزامی)
   - توکن نمایندگی خود را از پنل ریسلر LicenZer دریافت کنید
   - این توکن در پروفایل ریسلر شما موجود است

2. **API URL** (الزامی)
   - آدرس پایه سیستم LicenZer شما
   - مثال: `https://licenzer.pro`

3. **Allow IP Change by Client**
   - بله: کلاینت می‌تواند IP لایسنس را تغییر دهد
   - خیر: فقط ادمین می‌تواند IP را تغییر دهد

4. **Maximum IP Changes**
   - تعداد مجاز تغییر IP توسط کلاینت
   - `0` = نامحدود
   - عدد مثبت = محدود به همان تعداد

5. **Enable Discount Licenses**
   - بله: فعال‌سازی گروه لایسنس‌های تخفیف‌دار
   - خیر: غیرفعال

6. **Auto-Add Products to WHMCS**
   - بله: به صورت خودکار محصولات را به WHMCS اضافه می‌کند
   - خیر: باید به صورت دستی اضافه کنید

### 2. نصب Addon Module

#### آپلود فایل‌ها

فایل‌های Addon Module را در مسیر زیر کپی کنید:
```
modules/addons/licenzer/
```

#### فعال‌سازی Addon

1. از پنل ادمین WHMCS به بخش **Setup > Addon Modules** بروید
2. "LicenZer License Manager" را پیدا کنید
3. روی **Activate** کلیک کنید
4. تنظیمات را پر کنید:
   - **API URL**: آدرس پایه API سیستم LicenZer
   - **Reseller Token**: توکن نمایندگی خود را وارد کنید

### 3. اضافه کردن محصولات

بعد از نصب، می‌توانید:
- به صورت خودکار محصولات را اضافه کنید (اگر در نصب کننده فعال کرده باشید)
- یا به صورت دستی محصولات را ایجاد کنید

برای هر نرم‌افزار یک محصول جداگانه ایجاد کنید و نوع سرور را **LicenZer License Manager** انتخاب کنید.

## استفاده

### بخش Admin (Addon Module)

از منوی **Addons > LicenZer License Manager** می‌توانید به بخش‌های زیر دسترسی داشته باشید:

1. **Dashboard**: آمار کامل و لایسنس‌های اخیر
2. **All Licenses**: مدیریت کامل تمام لایسنس‌ها
   - مشاهده لیست کامل
   - جستجو و فیلتر
   - تغییر IP
   - مشاهده جزئیات
3. **Discount Licenses**: مدیریت لایسنس‌های تخفیف‌دار
   - مشاهده لایسنس‌های تخفیف‌دار
   - اختصاص به سرویس‌ها
4. **Settings**: تنظیمات Addon

### بخش Client (Server Module)

کلاینت‌ها می‌توانند:

1. اطلاعات لایسنس را مشاهده کنند
2. دستور نصب را کپی کنند
3. IP لایسنس را تغییر دهند (در صورت فعال بودن)

### لایسنس‌های تخفیف‌دار

لایسنس‌هایی که قبلاً فعال شده‌اند و هزینه راه‌اندازی ندارند، با 50% تخفیف در دسترس هستند.

## پشتیبانی

برای پشتیبانی با تیم LicenZer تماس بگیرید.

