<?php
/**
 * LicenZer Admin Settings Template
 */

// Handle save
if ($_POST['action'] ?? '' == 'save_settings') {
    // Settings are saved through WHMCS addon configuration
    echo '<div class="alert alert-success">Settings saved successfully!</div>';
}

?>

<div class="licenzer-admin-settings">
    <div class="page-header">
        <h2>Settings</h2>
        <p>Configure LicenZer addon settings</p>
    </div>
    
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">API Configuration</h3>
        </div>
        <div class="panel-body">
            <form method="post" action="configaddonmods.php">
                <input type="hidden" name="action" value="save">
                <input type="hidden" name="module" value="licenzer">
                
                <div class="form-group">
                    <label>API URL:</label>
                    <input type="text" name="api_url" class="form-control" value="<?php echo htmlspecialchars($apiUrl); ?>" required placeholder="https://licenzer.pro">
                    <small class="form-text text-muted">Base URL of your LicenZer installation (without trailing slash)</small>
                </div>
                
                <div class="form-group">
                    <label>Reseller Token:</label>
                    <input type="text" name="reseller_token" class="form-control" value="<?php echo htmlspecialchars($resellerToken); ?>" required placeholder="Enter your reseller token">
                    <small class="form-text text-muted">Your LicenZer reseller token (found in your reseller panel profile)</small>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Settings
                    </button>
                    <a href="<?php echo $modulelink; ?>&action=installer" class="btn btn-info">
                        <i class="fas fa-cog"></i> Run Installer
                    </a>
                </div>
            </form>
        </div>
    </div>
    
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Information</h3>
        </div>
        <div class="panel-body">
            <p><strong>Addon Version:</strong> <?php echo $version; ?></p>
            <p><strong>API Status:</strong> 
                <?php
                require_once __DIR__ . '/../helper.php';
                $api = new LicenZerAPIHelper($apiUrl, $resellerToken);
                $status = $api->testConnection();
                if ($status['success']) {
                    echo '<span class="label label-success">Connected</span>';
                } else {
                    echo '<span class="label label-danger">Disconnected</span>';
                }
                ?>
            </p>
        </div>
    </div>
</div>

