<?php
/**
 * LicenZer Admin Licenses Management Template
 */

require_once __DIR__ . '/../helper.php';

$api = new LicenZerAPIHelper($apiUrl, $resellerToken);

// Handle actions
if ($_POST['action'] ?? '' == 'change_ip') {
    $result = $api->changeIp($_POST['license_key'], $_POST['new_ip']);
    if ($result['success']) {
        echo '<div class="alert alert-success">IP changed successfully</div>';
    } else {
        echo '<div class="alert alert-danger">' . htmlspecialchars($result['message']) . '</div>';
    }
}

// Get all licenses
$licenses = $api->getAllLicenses();

?>

<div class="licenzer-admin-licenses">
    <div class="page-header">
        <h2>All Licenses</h2>
        <p>Manage all LicenZer licenses</p>
    </div>
    
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Licenses List</h3>
        </div>
        <div class="panel-body">
            <table class="table table-striped table-bordered" id="licensesTable">
                <thead>
                    <tr>
                        <th>License Key</th>
                        <th>IP Address</th>
                        <th>Software</th>
                        <th>Status</th>
                        <th>Expiry Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    if (empty($licenses)): 
                        echo '<tr><td colspan="6" class="text-center">No licenses found</td></tr>';
                    else:
                        foreach ($licenses as $license): 
                    ?>
                    <tr>
                        <td><code><?php echo htmlspecialchars($license['license_key'] ?? 'N/A'); ?></code></td>
                        <td><?php echo htmlspecialchars($license['ip'] ?? 'N/A'); ?></td>
                        <td><?php echo htmlspecialchars($license['software_name'] ?? $license['key'] ?? 'N/A'); ?></td>
                        <td>
                            <span class="label label-<?php echo ($license['status'] ?? 0) ? 'success' : 'danger'; ?>">
                                <?php echo ($license['status'] ?? 0) ? 'Active' : 'Inactive'; ?>
                            </span>
                        </td>
                        <td><?php echo htmlspecialchars($license['end_at'] ?? $license['Expired date'] ?? 'N/A'); ?></td>
                        <td>
                            <a href="<?php echo $modulelink; ?>&action=view&license_key=<?php echo urlencode($license['license_key'] ?? ''); ?>" class="btn btn-sm btn-info">
                                <i class="fas fa-eye"></i> View
                            </a>
                            <button class="btn btn-sm btn-warning" onclick="changeIp('<?php echo htmlspecialchars($license['license_key'] ?? ''); ?>', '<?php echo htmlspecialchars($license['ip'] ?? ''); ?>')">
                                <i class="fas fa-exchange-alt"></i> Change IP
                            </button>
                        </td>
                    </tr>
                    <?php 
                        endforeach;
                    endif;
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Change IP Modal -->
<div class="modal fade" id="changeIpModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form method="post" action="<?php echo $modulelink; ?>&action=licenses">
                <input type="hidden" name="action" value="change_ip">
                <input type="hidden" name="license_key" id="modal_license_key">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Change IP Address</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Current IP:</label>
                        <input type="text" class="form-control" id="modal_current_ip" readonly>
                    </div>
                    <div class="form-group">
                        <label>New IP Address:</label>
                        <input type="text" name="new_ip" class="form-control" required pattern="^([0-9]{1,3}\.){3}[0-9]{1,3}$" placeholder="192.168.1.1">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Change IP</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// View license is handled by link, no need for function

function changeIp(licenseKey, currentIp) {
    document.getElementById('modal_license_key').value = licenseKey;
    document.getElementById('modal_current_ip').value = currentIp;
    $('#changeIpModal').modal('show');
}

$(document).ready(function() {
    $('#licensesTable').DataTable({
        "order": [[4, "desc"]],
        "pageLength": 25
    });
});
</script>

