<?php
/**
 * LicenZer Addon Installer Template
 * This installer runs when addon is first activated or settings are not configured
 */

// Handle installer submission
if ($_POST['action'] ?? '' == 'install') {
    // Save settings through WHMCS addon configuration
    // Settings will be saved via configaddonmods.php
    
    echo '<div class="alert alert-success">';
    echo '<h4>Installation Complete!</h4>';
    echo '<p>Please configure the addon settings:</p>';
    echo '<ol>';
    echo '<li>Go to <strong>Setup > Addon Modules</strong></li>';
    echo '<li>Find "LicenZer License Manager"</li>';
    echo '<li>Click "Configure"</li>';
    echo '<li>Enter the following settings:</li>';
    echo '<ul>';
    echo '<li><strong>API URL:</strong> ' . htmlspecialchars($_POST['api_url'] ?? '') . '</li>';
    echo '<li><strong>Reseller Token:</strong> ' . htmlspecialchars($_POST['reseller_token'] ?? '') . '</li>';
    echo '</ul>';
    echo '<li>Save the settings</li>';
    echo '<li>Return to this addon to continue</li>';
    echo '</ol>';
    echo '<p><a href="' . $modulelink . '" class="btn btn-primary">Continue to Dashboard</a></p>';
    echo '</div>';
    
    // Store installer data temporarily (will be used when configuring)
    if (!empty($_POST['api_url']) && !empty($_POST['reseller_token'])) {
        try {
            if (Capsule::schema()->hasTable('licenzer_settings')) {
                Capsule::table('licenzer_settings')->updateOrInsert(
                    ['setting_key' => 'installer_api_url'],
                    ['setting_value' => $_POST['api_url']]
                );
                Capsule::table('licenzer_settings')->updateOrInsert(
                    ['setting_key' => 'installer_reseller_token'],
                    ['setting_value' => $_POST['reseller_token']]
                );
            }
        } catch (Exception $e) {
            // Table might not exist yet, that's okay
        }
    }
    
    return;
}

// Get installer data if exists
$installerData = [];
try {
    if (Capsule::schema()->hasTable('licenzer_settings')) {
        $installerData = Capsule::table('licenzer_settings')
            ->whereIn('setting_key', ['installer_api_url', 'installer_reseller_token'])
            ->pluck('setting_value', 'setting_key')
            ->toArray();
    }
} catch (Exception $e) {
    // Table doesn't exist yet, that's okay
}

?>

<div class="licenzer-admin-installer">
    <div class="page-header">
        <h2>LicenZer Module Installation</h2>
        <p>Welcome to LicenZer WHMCS Module installer. Please configure the following settings:</p>
    </div>
    
    <div class="alert alert-info">
        <i class="fas fa-info-circle"></i>
        <strong>Note:</strong> After completing this installer, you'll need to configure the addon settings in <strong>Setup > Addon Modules</strong>.
    </div>
    
    <form method="post" action="<?php echo $modulelink; ?>&action=installer">
        <input type="hidden" name="action" value="install">
        
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Basic Configuration</h3>
            </div>
            <div class="panel-body">
                <div class="form-group">
                    <label>Reseller Token <span class="text-danger">*</span></label>
                    <input type="text" name="reseller_token" class="form-control" required 
                           placeholder="Enter your LicenZer reseller token"
                           value="<?php echo htmlspecialchars($installerData['installer_reseller_token'] ?? ''); ?>">
                    <small class="form-text text-muted">
                        <i class="fas fa-info-circle"></i> You can find your token in your LicenZer reseller panel (Profile section)
                    </small>
                </div>
                
                <div class="form-group">
                    <label>API URL <span class="text-danger">*</span></label>
                    <input type="text" name="api_url" class="form-control" required 
                           placeholder="https://licenzer.pro"
                           value="<?php echo htmlspecialchars($installerData['installer_api_url'] ?? 'https://licenzer.pro'); ?>">
                    <small class="form-text text-muted">
                        <i class="fas fa-info-circle"></i> Base URL of your LicenZer installation (without trailing slash). Default: https://licenzer.pro
                    </small>
                </div>
            </div>
        </div>
        
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Server Module Settings</h3>
            </div>
            <div class="panel-body">
                <div class="form-group">
                    <label>Allow IP Change by Client</label>
                    <select name="allow_ip_change" class="form-control">
                        <option value="yes">Yes - Clients can change IP address</option>
                        <option value="no" selected>No - Only admin can change IP</option>
                    </select>
                    <small class="form-text text-muted">
                        Allow clients to change license IP address from their client area
                    </small>
                </div>
                
                <div class="form-group">
                    <label>Maximum IP Changes</label>
                    <input type="number" name="max_ip_changes" class="form-control" value="0" min="0">
                    <small class="form-text text-muted">
                        Maximum number of IP changes allowed per license (0 = unlimited)
                    </small>
                </div>
                
                <div class="form-group">
                    <label>Enable Discount Licenses</label>
                    <select name="enable_discount" class="form-control">
                        <option value="yes">Yes - Enable discount licenses group</option>
                        <option value="no" selected>No - Disable discount licenses</option>
                    </select>
                    <small class="form-text text-muted">
                        Enable discount licenses group (previously activated licenses available at 50% discount)
                    </small>
                </div>
            </div>
        </div>
        
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Product Setup</h3>
            </div>
            <div class="panel-body">
                <div class="form-group">
                    <label>Auto-Add Products to WHMCS</label>
                    <select name="auto_add_products" class="form-control">
                        <option value="yes">Yes - Automatically add available software as products</option>
                        <option value="no" selected>No - Add products manually</option>
                    </select>
                    <small class="form-text text-muted">
                        Automatically create products in WHMCS for each available software in your LicenZer system
                    </small>
                </div>
                
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i>
                    <strong>Note:</strong> If you choose "Yes", the system will attempt to create products automatically. 
                    You can always add products manually later from <strong>Setup > Products/Services > Products/Services</strong>.
                </div>
            </div>
        </div>
        
        <div class="form-group">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-check"></i> Install & Configure
            </button>
            <a href="<?php echo $modulelink; ?>" class="btn btn-default btn-lg">
                <i class="fas fa-times"></i> Cancel
            </a>
        </div>
    </form>
    
    <div class="alert alert-info mt-4">
        <h4><i class="fas fa-lightbulb"></i> Next Steps After Installation:</h4>
        <ol>
            <li>Configure addon settings in <strong>Setup > Addon Modules > LicenZer License Manager > Configure</strong></li>
            <li>Add server in <strong>Setup > Products/Services > Servers</strong> (type: LicenZer License Manager)</li>
            <li>Create products for each software you want to sell</li>
            <li>Start selling licenses!</li>
        </ol>
    </div>
</div>

<style>
.licenzer-admin-installer {
    padding: 20px;
    max-width: 900px;
    margin: 0 auto;
}

.licenzer-admin-installer .panel {
    margin-bottom: 20px;
}

.licenzer-admin-installer .form-group {
    margin-bottom: 20px;
}

.licenzer-admin-installer label {
    font-weight: bold;
    color: #333;
}

.licenzer-admin-installer .text-danger {
    color: #dc3545;
}
</style>

