<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use WHMCS\Database\Capsule;

/**
 * LicenZer Admin Addon
 * 
 * This addon provides admin functionality for managing LicenZer licenses
 * Separated from server module for better organization and easier development
 */

function licenzer_config()
{
    return array(
        'name' => 'LicenZer License Manager',
        'description' => 'Admin panel for managing LicenZer licenses, discount licenses, and settings',
        'version' => '1.0.0',
        'author' => 'LicenZer',
        'language' => 'english',
        'fields' => array(
            'api_url' => array(
                'FriendlyName' => 'API URL',
                'Type' => 'text',
                'Size' => '100',
                'Default' => 'https://licenzer.pro',
                'Description' => 'LicenZer API base URL',
            ),
            'reseller_token' => array(
                'FriendlyName' => 'Reseller Token',
                'Type' => 'text',
                'Size' => '50',
                'Description' => 'Your LicenZer reseller token',
            ),
        )
    );
}

function licenzer_activate()
{
    // Create custom tables if needed
    try {
        // Check if table already exists
        if (!Capsule::schema()->hasTable('licenzer_settings')) {
            Capsule::schema()->create('licenzer_settings', function ($table) {
                $table->increments('id');
                $table->string('setting_key')->unique();
                $table->text('setting_value')->nullable();
                $table->timestamps();
            });
        }
        
        // Show installer on first activation if settings are not configured
        $apiUrl = Capsule::table('tbladdonmodules')
            ->where('module', 'licenzer')
            ->where('setting', 'api_url')
            ->first();
        
        if (!$apiUrl || empty($apiUrl->value)) {
            return array(
                'status' => 'success',
                'description' => 'LicenZer addon activated successfully. Please configure the settings and run the installer from Addons menu.'
            );
        }
        
        return array(
            'status' => 'success',
            'description' => 'LicenZer addon activated successfully. You can now access it from Addons menu.'
        );
    } catch (Exception $e) {
        // Table might already exist, that's okay
        return array(
            'status' => 'success',
            'description' => 'LicenZer addon activated successfully'
        );
    }
}

function licenzer_deactivate()
{
    // Optionally drop tables on deactivation
    // For now, we'll keep the data
    return array(
        'status' => 'success',
        'description' => 'LicenZer addon deactivated successfully'
    );
}

function licenzer_upgrade($vars)
{
    $version = $vars['version'];
    // Handle upgrade logic here
    return array(
        'status' => 'success',
        'description' => 'LicenZer addon upgraded successfully'
    );
}

function licenzer_output($vars)
{
    $modulelink = $vars['modulelink'];
    $version = $vars['version'];
    $LANG = $vars['_lang'];
    
    // Get settings
    $apiUrl = $vars['api_url'] ?? '';
    $resellerToken = $vars['reseller_token'] ?? '';
    
    // If settings are not configured, show installer
    if (empty($apiUrl) || empty($resellerToken)) {
        // Don't override action if installer is explicitly requested
        if (($_GET['action'] ?? '') != 'installer') {
            $action = 'installer';
        }
    }
    
    // Include helper
    require_once __DIR__ . '/helper.php';
    
    // Get action
    $action = $_GET['action'] ?? 'dashboard';
    
    // Check if installer should be shown
    if (empty($apiUrl) || empty($resellerToken)) {
        $action = 'installer';
    }
    
    // Include CSS
    echo '<link rel="stylesheet" href="modules/addons/licenzer/css/admin.css">';
    
    // Include sidebar (except for installer)
    if ($action != 'installer') {
        echo licenzer_sidebar($vars);
    }
    
    // Include appropriate template
    switch ($action) {
        case 'installer':
            include_once __DIR__ . '/templates/admin_installer.php';
            break;
        case 'dashboard':
            include_once __DIR__ . '/templates/admin_dashboard.php';
            break;
        case 'licenses':
            include_once __DIR__ . '/templates/admin_licenses.php';
            break;
        case 'discount':
            include_once __DIR__ . '/templates/admin_discount.php';
            break;
        case 'settings':
            include_once __DIR__ . '/templates/admin_settings.php';
            break;
        case 'view':
            include_once __DIR__ . '/templates/admin_view_license.php';
            break;
        default:
            include_once __DIR__ . '/templates/admin_dashboard.php';
    }
}

function licenzer_sidebar($vars)
{
    $modulelink = $vars['modulelink'];
    $version = $vars['version'];
    $LANG = $vars['_lang'];
    
    $currentAction = $_GET['action'] ?? 'dashboard';
    
    $sidebar = '<div class="licenzer-sidebar">';
    $sidebar .= '<h3>LicenZer Manager</h3>';
    $sidebar .= '<ul class="menu">';
    $sidebar .= '<li><a href="' . $modulelink . '&action=dashboard" class="' . ($currentAction == 'dashboard' ? 'active' : '') . '">Dashboard</a></li>';
    $sidebar .= '<li><a href="' . $modulelink . '&action=licenses" class="' . ($currentAction == 'licenses' ? 'active' : '') . '">All Licenses</a></li>';
    $sidebar .= '<li><a href="' . $modulelink . '&action=discount" class="' . ($currentAction == 'discount' ? 'active' : '') . '">Discount Licenses</a></li>';
    $sidebar .= '<li><a href="' . $modulelink . '&action=settings" class="' . ($currentAction == 'settings' ? 'active' : '') . '">Settings</a></li>';
    $sidebar .= '</ul>';
    $sidebar .= '</div>';
    
    return $sidebar;
}

/**
 * Admin area hooks
 */
add_hook('AdminAreaPage', 1, function($vars) {
    // Add custom CSS/JS if needed
});

/**
 * Service management hooks
 */
add_hook('AdminServicesTabFields', 1, function($vars) {
    // This will be handled by the server module
});

add_hook('AdminServicesTabFieldsSave', 1, function($vars) {
    // This will be handled by the server module
});

