# ساختار ماژول LicenZer برای WHMCS

## ساختار کلی

```
whmcs-licenzer-module/
├── modules/
│   ├── servers/
│   │   └── licenzer/          # Server Module (برای سرویس‌ها و کلاینت)
│   │       ├── licenzer.php   # فایل اصلی ماژول
│   │       ├── installer.php  # نصب کننده
│   │       ├── templates/
│   │       │   ├── client.tpl # تمپلیت کلاینت
│   │       │   └── admin.tpl  # تمپلیت ادمین (ساده)
│   │       ├── lang/
│   │       │   └── english.php
│   │       ├── README.md
│   │       ├── INSTALL.md
│   │       └── CHANGELOG.md
│   │
│   └── addons/
│       └── licenzer/           # Addon Module (برای مدیریت ادمین)
│           ├── licenzer.php    # فایل اصلی Addon
│           ├── helper.php      # کلاس Helper برای API
│           ├── templates/
│           │   ├── admin_dashboard.php
│           │   ├── admin_licenses.php
│           │   ├── admin_discount.php
│           │   ├── admin_settings.php
│           │   └── admin_view_license.php
│           ├── css/
│           │   └── admin.css
│           ├── lang/
│           │   └── english.php
│           └── README.md
│
├── README.md                   # مستندات اصلی
└── STRUCTURE.md                # این فایل
```

## تفکیک وظایف

### Server Module (`modules/servers/licenzer/`)
**وظیفه:** مدیریت سرویس‌ها و بخش کلاینت

**قابلیت‌ها:**
- ایجاد، فعال‌سازی، غیرفعال‌سازی، حذف لایسنس
- نمایش اطلاعات لایسنس به کلاینت
- تغییر IP توسط کلاینت (در صورت فعال بودن)
- نمایش دستور نصب
- مدیریت محدودیت تغییر IP

**محدودیت‌ها:**
- فقط برای مدیریت سرویس‌های خاص
- بخش Admin ساده (فقط View License Info)

### Addon Module (`modules/addons/licenzer/`)
**وظیفه:** مدیریت ادمین و قابلیت‌های پیشرفته

**قابلیت‌ها:**
- Dashboard با آمار کامل
- مدیریت متمرکز تمام لایسنس‌ها
- جستجو و فیلتر با DataTables
- تغییر IP لایسنس‌ها
- مدیریت لایسنس‌های تخفیف‌دار
- اختصاص لایسنس تخفیف‌دار به سرویس‌ها
- مشاهده جزئیات کامل لایسنس
- مشاهده دستور نصب

**مزایا:**
- دسترسی از منوی Addons
- مدیریت متمرکز
- توسعه راحت‌تر در آینده

## نحوه استفاده

### برای ادمین
1. از منوی **Addons > LicenZer License Manager** استفاده کنید
2. Dashboard برای آمار کلی
3. All Licenses برای مدیریت کامل
4. Discount Licenses برای لایسنس‌های تخفیف‌دار

### برای کلاینت
1. از بخش **My Services** در Client Area
2. روی سرویس لایسنس کلیک کنید
3. اطلاعات لایسنس و دستور نصب را مشاهده کنید
4. در صورت فعال بودن، IP را تغییر دهید

## توسعه در آینده

با این ساختار، می‌توانید به راحتی:
- قابلیت‌های جدید به Addon اضافه کنید
- Server Module را مستقل نگه دارید
- هر بخش را به صورت جداگانه به‌روزرسانی کنید
- کد تمیزتر و قابل نگهداری‌تر داشته باشید

