<?php
/**
 * Customer Licenses Controller
 */
class ControllerAccountLicenzer extends Controller {
    
    public function index() {
        if (!$this->customer->isLogged()) {
            $this->session->data['redirect'] = $this->url->link('account/licenzer', '', true);
            $this->response->redirect($this->url->link('account/login', '', true));
        }

        $this->load->language('account/licenzer');
        $this->document->setTitle($this->language->get('heading_title'));

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_account'),
            'href' => $this->url->link('account/account', '', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('account/licenzer', '', true)
        );

        $this->load->model('account/licenzer');
        $data['licenses'] = $this->model_account_licenzer->getCustomerLicenses($this->customer->getId());
        $data['allow_ip_change'] = $this->config->get('module_licenzer_allow_ip_change');
        $data['change_ip'] = $this->url->link('account/licenzer/changeIp', '', true);
        $data['continue'] = $this->url->link('account/account', '', true);

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        $this->response->setOutput($this->load->view('account/licenzer', $data));
    }

    public function changeIp() {
        $this->load->language('account/licenzer');

        $json = array();

        if (!$this->customer->isLogged()) {
            $json['error'] = $this->language->get('error_login');
        } else {
            $license_key = isset($this->request->post['license_key']) ? $this->request->post['license_key'] : '';
            $new_ip = isset($this->request->post['new_ip']) ? $this->request->post['new_ip'] : '';

            if (empty($license_key) || empty($new_ip)) {
                $json['error'] = $this->language->get('error_missing_data');
            } elseif (!filter_var($new_ip, FILTER_VALIDATE_IP)) {
                $json['error'] = $this->language->get('error_invalid_ip');
            } else {
                $this->load->model('account/licenzer');
                $result = $this->model_account_licenzer->changeIp($license_key, $new_ip, $this->customer->getId());

                if (isset($result['status']) && $result['status'] == 'success') {
                    $json['success'] = $this->language->get('text_ip_changed');
                } else {
                    $json['error'] = isset($result['message']) ? $result['message'] : $this->language->get('error_ip_change_failed');
                }
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
}

