<?php
/**
 * LicenZer Module Controller
 */
class ControllerExtensionModuleLicenzer extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/module/licenzer');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('module_licenzer', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/licenzer', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/module/licenzer', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

        // Load settings
        if (isset($this->request->post['module_licenzer_api_url'])) {
            $data['module_licenzer_api_url'] = $this->request->post['module_licenzer_api_url'];
        } else {
            $data['module_licenzer_api_url'] = $this->config->get('module_licenzer_api_url') ?: 'https://licenzer.pro';
        }

        if (isset($this->request->post['module_licenzer_reseller_token'])) {
            $data['module_licenzer_reseller_token'] = $this->request->post['module_licenzer_reseller_token'];
        } else {
            $data['module_licenzer_reseller_token'] = $this->config->get('module_licenzer_reseller_token');
        }

        if (isset($this->request->post['module_licenzer_allow_ip_change'])) {
            $data['module_licenzer_allow_ip_change'] = $this->request->post['module_licenzer_allow_ip_change'];
        } else {
            $data['module_licenzer_allow_ip_change'] = $this->config->get('module_licenzer_allow_ip_change');
        }

        if (isset($this->request->post['module_licenzer_max_ip_changes'])) {
            $data['module_licenzer_max_ip_changes'] = $this->request->post['module_licenzer_max_ip_changes'];
        } else {
            $data['module_licenzer_max_ip_changes'] = $this->config->get('module_licenzer_max_ip_changes') ?: '0';
        }

        if (isset($this->request->post['module_licenzer_enable_discount'])) {
            $data['module_licenzer_enable_discount'] = $this->request->post['module_licenzer_enable_discount'];
        } else {
            $data['module_licenzer_enable_discount'] = $this->config->get('module_licenzer_enable_discount');
        }

        if (isset($this->request->post['module_licenzer_status'])) {
            $data['module_licenzer_status'] = $this->request->post['module_licenzer_status'];
        } else {
            $data['module_licenzer_status'] = $this->config->get('module_licenzer_status');
        }

        // Quick links
        $data['dashboard_link'] = $this->url->link('extension/module/licenzer/dashboard', 'user_token=' . $this->session->data['user_token'], true);
        $data['licenses_link'] = $this->url->link('extension/module/licenzer/licenses', 'user_token=' . $this->session->data['user_token'], true);
        $data['discount_link'] = $this->url->link('extension/module/licenzer/discount', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/licenzer', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/module/licenzer')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    /**
     * Dashboard
     */
    public function dashboard() {
        $this->load->language('extension/module/licenzer');
        $this->document->setTitle($this->language->get('heading_dashboard'));

        $this->load->model('extension/module/licenzer');

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/licenzer/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        // Get statistics
        $data['stats'] = $this->model_extension_module_licenzer->getStatistics();
        $data['recent_licenses'] = $this->model_extension_module_licenzer->getRecentLicenses(10);
        
        // Quick links
        $data['licenses_link'] = $this->url->link('extension/module/licenzer/licenses', 'user_token=' . $this->session->data['user_token'], true);
        $data['discount_link'] = $this->url->link('extension/module/licenzer/discount', 'user_token=' . $this->session->data['user_token'], true);
        $data['settings_link'] = $this->url->link('extension/module/licenzer', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/licenzer_dashboard', $data));
    }

    /**
     * Licenses list
     */
    public function licenses() {
        $this->load->language('extension/module/licenzer');
        $this->document->setTitle($this->language->get('heading_licenses'));

        $this->load->model('extension/module/licenzer');

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/licenzer/licenses', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['licenses'] = $this->model_extension_module_licenzer->getLicenses();
        $data['change_ip'] = $this->url->link('extension/module/licenzer/changeIp', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/licenzer_licenses', $data));
    }

    /**
     * Change IP
     */
    public function changeIp() {
        $this->load->language('extension/module/licenzer');

        $json = array();

        if (!$this->user->hasPermission('modify', 'extension/module/licenzer')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            $license_key = isset($this->request->post['license_key']) ? $this->request->post['license_key'] : '';
            $new_ip = isset($this->request->post['new_ip']) ? $this->request->post['new_ip'] : '';
            $software_key = isset($this->request->post['software_key']) ? $this->request->post['software_key'] : '';
            $current_ip = isset($this->request->post['current_ip']) ? $this->request->post['current_ip'] : '';

            if (empty($license_key) || empty($new_ip) || empty($software_key)) {
                $json['error'] = $this->language->get('error_missing_data');
            } elseif (!filter_var($new_ip, FILTER_VALIDATE_IP)) {
                $json['error'] = $this->language->get('error_invalid_ip');
            } else {
                $this->load->model('extension/module/licenzer');
                $result = $this->model_extension_module_licenzer->changeIp($current_ip, $new_ip, $software_key);

                if (isset($result['status']) && $result['status'] == 'success') {
                    $json['success'] = $this->language->get('text_ip_changed');
                } else {
                    $json['error'] = isset($result['message']) ? $result['message'] : $this->language->get('error_ip_change_failed');
                }
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    /**
     * Discount licenses
     */
    public function discount() {
        $this->load->language('extension/module/licenzer');
        $this->document->setTitle($this->language->get('heading_discount'));

        $this->load->model('extension/module/licenzer');

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/licenzer/discount', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['discount_licenses'] = $this->model_extension_module_licenzer->getDiscountLicenses();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/licenzer_discount', $data));
    }
}

