<?php

namespace Licenzer\Licenzer;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;

class LicenzerServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../config/licenzer.php',
            'licenzer'
        );

        $this->app->singleton('licenzer.api', function ($app) {
            return new LicenzerApi(
                config('licenzer.api_url', 'https://licenzer.pro'),
                config('licenzer.reseller_token', '')
            );
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        $this->loadRoutes();
        $this->loadViews();
        $this->loadMigrations();
        $this->publishAssets();
    }

    /**
     * Load routes
     */
    protected function loadRoutes(): void
    {
        Route::middleware(['web'])
            ->prefix('licenzer')
            ->group(function () {
                // Admin routes
                Route::middleware(config('licenzer.admin_middleware', ['auth']))->prefix('admin')->group(function () {
                    Route::get('/dashboard', [\Licenzer\Licenzer\Controllers\Admin\DashboardController::class, 'index'])->name('licenzer.admin.dashboard');
                    Route::get('/licenses', [\Licenzer\Licenzer\Controllers\Admin\LicenseController::class, 'index'])->name('licenzer.admin.licenses');
                    Route::post('/licenses/change-ip', [\Licenzer\Licenzer\Controllers\Admin\LicenseController::class, 'changeIp'])->name('licenzer.admin.licenses.changeIp');
                    Route::get('/discount', [\Licenzer\Licenzer\Controllers\Admin\DiscountController::class, 'index'])->name('licenzer.admin.discount');
                    Route::get('/settings', [\Licenzer\Licenzer\Controllers\Admin\SettingsController::class, 'index'])->name('licenzer.admin.settings');
                    Route::post('/settings', [\Licenzer\Licenzer\Controllers\Admin\SettingsController::class, 'update'])->name('licenzer.admin.settings.update');
                });

                // Customer routes
                Route::middleware(config('licenzer.customer_middleware', ['auth']))->prefix('customer')->group(function () {
                    Route::get('/licenses', [\Licenzer\Licenzer\Controllers\Customer\LicenseController::class, 'index'])->name('licenzer.customer.licenses');
                    Route::post('/licenses/change-ip', [\Licenzer\Licenzer\Controllers\Customer\LicenseController::class, 'changeIp'])->name('licenzer.customer.licenses.changeIp');
                });
            });
    }

    /**
     * Load views
     */
    protected function loadViews(): void
    {
        $this->loadViewsFrom(__DIR__ . '/../resources/views', 'licenzer');
    }

    /**
     * Load migrations
     */
    protected function loadMigrations(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');
    }

    /**
     * Publish assets
     */
    protected function publishAssets(): void
    {
        $this->publishes([
            __DIR__ . '/../config/licenzer.php' => config_path('licenzer.php'),
        ], 'licenzer-config');

        $this->publishes([
            __DIR__ . '/../resources/views' => resource_path('views/vendor/licenzer'),
        ], 'licenzer-views');
    }
}

