<?php

namespace Licenzer\Licenzer\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Licenzer\Licenzer\LicenzerApi;

class SettingsController extends Controller
{
    private $api;

    public function __construct()
    {
        $this->api = app('licenzer.api');
    }

    public function index()
    {
        $connectionStatus = $this->api->testConnection();
        return view('licenzer::admin.settings', compact('connectionStatus'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'api_url' => 'required|url',
            'reseller_token' => 'required|string',
            'allow_ip_change' => 'boolean',
            'max_ip_changes' => 'integer|min:0',
            'enable_discount' => 'boolean',
        ]);

        // Update config file or database
        $config = [
            'api_url' => $request->api_url,
            'reseller_token' => $request->reseller_token,
            'allow_ip_change' => $request->has('allow_ip_change'),
            'max_ip_changes' => $request->max_ip_changes ?? 0,
            'enable_discount' => $request->has('enable_discount'),
        ];

        // Save to config file
        $configPath = config_path('licenzer.php');
        file_put_contents($configPath, '<?php return ' . var_export($config, true) . ';');

        return redirect()->route('licenzer.admin.settings')
            ->with('success', 'Settings updated successfully');
    }
}

