<?php

namespace Licenzer\Licenzer\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Licenzer\Licenzer\LicenzerApi;

class LicenseController extends Controller
{
    private $api;

    public function __construct()
    {
        $this->api = app('licenzer.api');
    }

    public function index()
    {
        $licenses = $this->api->getLicenses();
        $licenseList = [];

        if (isset($licenses['status']) && $licenses['status'] == 'success') {
            $licenseList = $licenses['data'] ?? [];
        }

        return view('licenzer::admin.licenses', compact('licenseList'));
    }

    public function changeIp(Request $request)
    {
        $request->validate([
            'license_key' => 'required|string',
            'current_ip' => 'required|ip',
            'new_ip' => 'required|ip',
            'software_key' => 'required|string',
        ]);

        $result = $this->api->changeIp(
            $request->current_ip,
            $request->new_ip,
            $request->software_key
        );

        if (isset($result['status']) && $result['status'] == 'success') {
            return redirect()->route('licenzer.admin.licenses')
                ->with('success', 'IP address changed successfully');
        }

        return redirect()->route('licenzer.admin.licenses')
            ->with('error', $result['message'] ?? 'Failed to change IP address');
    }
}

