@extends('licenzer::layouts.admin')

@section('title', 'Settings')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h1>LicenZer Settings</h1>
        </div>
    </div>

    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('licenzer.admin.settings.update') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label for="api_url" class="form-label">API URL</label>
                            <input type="url" class="form-control" id="api_url" name="api_url" 
                                   value="{{ config('licenzer.api_url', 'https://licenzer.pro') }}" required>
                            <small class="form-text text-muted">Base URL of your LicenZer installation (without trailing slash).</small>
                        </div>

                        <div class="mb-3">
                            <label for="reseller_token" class="form-label">Reseller Token</label>
                            <input type="text" class="form-control" id="reseller_token" name="reseller_token" 
                                   value="{{ config('licenzer.reseller_token') }}" required>
                            <small class="form-text text-muted">Your LicenZer reseller token (found in your reseller panel profile).</small>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="allow_ip_change" name="allow_ip_change" 
                                       {{ config('licenzer.allow_ip_change') ? 'checked' : '' }}>
                                <label class="form-check-label" for="allow_ip_change">
                                    Allow IP Change by Client
                                </label>
                            </div>
                            <small class="form-text text-muted">Allow clients to change license IP address from their account.</small>
                        </div>

                        <div class="mb-3">
                            <label for="max_ip_changes" class="form-label">Maximum IP Changes</label>
                            <input type="number" class="form-control" id="max_ip_changes" name="max_ip_changes" 
                                   value="{{ config('licenzer.max_ip_changes', 0) }}" min="0">
                            <small class="form-text text-muted">Maximum number of IP changes allowed per license (0 = unlimited).</small>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="enable_discount" name="enable_discount" 
                                       {{ config('licenzer.enable_discount') ? 'checked' : '' }}>
                                <label class="form-check-label" for="enable_discount">
                                    Enable Discount Licenses
                                </label>
                            </div>
                            <small class="form-text text-muted">Enable discount licenses group (previously activated licenses available at 50% discount).</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">API Status</label>
                            <div>
                                @if($connectionStatus)
                                    <span class="badge bg-success">Connected</span>
                                @else
                                    <span class="badge bg-danger">Disconnected</span>
                                    <small class="form-text text-muted d-block">Please check your API URL and Reseller Token.</small>
                                @endif
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary">Save Settings</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

