<?php

return [
    /*
    |--------------------------------------------------------------------------
    | LicenZer API Configuration
    |--------------------------------------------------------------------------
    |
    | Configure your LicenZer API settings here.
    |
    */

    'api_url' => env('LICENZER_API_URL', 'https://licenzer.pro'),

    'reseller_token' => env('LICENZER_RESELLER_TOKEN', ''),

    /*
    |--------------------------------------------------------------------------
    | IP Change Settings
    |--------------------------------------------------------------------------
    |
    | Configure IP change permissions for customers.
    |
    */

    'allow_ip_change' => env('LICENZER_ALLOW_IP_CHANGE', false),

    'max_ip_changes' => env('LICENZER_MAX_IP_CHANGES', 0), // 0 = unlimited

    /*
    |--------------------------------------------------------------------------
    | Discount Licenses
    |--------------------------------------------------------------------------
    |
    | Enable discount licenses feature.
    |
    */

    'enable_discount' => env('LICENZER_ENABLE_DISCOUNT', false),

    /*
    |--------------------------------------------------------------------------
    | Route Middleware
    |--------------------------------------------------------------------------
    |
    | Middleware to apply to admin routes.
    |
    */

    'admin_middleware' => ['auth', 'admin'], // You may need to create 'admin' middleware

    'customer_middleware' => ['auth'],
];

