<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.formvalidator');
HTMLHelper::_('behavior.keepalive');

$app = Factory::getApplication();
$user = Factory::getUser();

$model = $this->getModel();
$licenses = $model->getLicenses();

ToolbarHelper::title(Text::_('COM_LICENZER_SUBMENU_LICENSES'), 'licenses');
ToolbarHelper::preferences('com_licenzer');

LicenzerHelper::addSubmenu('licenses');
?>

<div class="row-fluid">
    <div id="j-main-container" class="span10">
        <div class="licenzer-licenses">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th><?php echo Text::_('COM_LICENZER_LICENSE_KEY'); ?></th>
                        <th><?php echo Text::_('COM_LICENZER_IP_ADDRESS'); ?></th>
                        <th><?php echo Text::_('COM_LICENZER_SOFTWARE'); ?></th>
                        <th><?php echo Text::_('COM_LICENZER_STATUS'); ?></th>
                        <th><?php echo Text::_('COM_LICENZER_EXPIRY_DATE'); ?></th>
                        <th><?php echo Text::_('COM_LICENZER_ACTIONS'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($licenses)): ?>
                        <tr>
                            <td colspan="6" class="text-center"><?php echo Text::_('COM_LICENZER_NO_LICENSES'); ?></td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($licenses as $license): ?>
                        <tr>
                            <td><code><?php echo htmlspecialchars($license['license_key'] ?? 'N/A'); ?></code></td>
                            <td><?php echo htmlspecialchars($license['ip'] ?? 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($license['software_name'] ?? $license['key'] ?? 'N/A'); ?></td>
                            <td>
                                <span class="label label-<?php echo ($license['status'] ?? 0) ? 'success' : 'important'; ?>">
                                    <?php echo ($license['status'] ?? 0) ? Text::_('COM_LICENZER_ACTIVE') : Text::_('COM_LICENZER_INACTIVE'); ?>
                                </span>
                            </td>
                            <td><?php echo htmlspecialchars($license['end_at'] ?? $license['Expired date'] ?? 'N/A'); ?></td>
                            <td>
                                <button class="btn btn-small change-ip-btn" 
                                        data-license-key="<?php echo htmlspecialchars($license['license_key'] ?? ''); ?>"
                                        data-current-ip="<?php echo htmlspecialchars($license['ip'] ?? ''); ?>"
                                        data-software-key="<?php echo htmlspecialchars($license['key'] ?? ''); ?>">
                                    <?php echo Text::_('COM_LICENZER_CHANGE_IP'); ?>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <div id="sidebar" class="span2">
        <?php echo HTMLHelper::_('sidebar.render'); ?>
    </div>
</div>

<!-- Change IP Modal -->
<div id="change-ip-modal" class="modal hide fade" style="display: none;">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">×</button>
        <h3><?php echo Text::_('COM_LICENZER_CHANGE_IP'); ?></h3>
    </div>
    <form method="post" action="<?php echo Route::_('index.php?option=com_licenzer&task=licenses.changeIp'); ?>">
        <?php echo HTMLHelper::_('form.token'); ?>
        <div class="modal-body">
            <input type="hidden" name="license_key" id="modal-license-key">
            <input type="hidden" name="software_key" id="modal-software-key">
            <input type="hidden" name="current_ip" id="modal-current-ip">
            
            <div class="control-group">
                <label class="control-label"><?php echo Text::_('COM_LICENZER_CURRENT_IP'); ?></label>
                <div class="controls">
                    <input type="text" id="modal-current-ip-display" class="input-large" readonly>
                </div>
            </div>
            <div class="control-group">
                <label class="control-label" for="new-ip"><?php echo Text::_('COM_LICENZER_NEW_IP'); ?></label>
                <div class="controls">
                    <input type="text" name="new_ip" id="new-ip" class="input-large" required pattern="^([0-9]{1,3}\.){3}[0-9]{1,3}$" placeholder="192.168.1.1">
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn" data-dismiss="modal"><?php echo Text::_('JCANCEL'); ?></button>
            <button type="submit" class="btn btn-primary"><?php echo Text::_('COM_LICENZER_CHANGE_IP'); ?></button>
        </div>
    </form>
</div>

<script>
jQuery(document).ready(function($) {
    $('.change-ip-btn').on('click', function() {
        var licenseKey = $(this).data('license-key');
        var currentIp = $(this).data('current-ip');
        var softwareKey = $(this).data('software-key');

        $('#modal-license-key').val(licenseKey);
        $('#modal-current-ip').val(currentIp);
        $('#modal-current-ip-display').val(currentIp);
        $('#modal-software-key').val(softwareKey);

        $('#change-ip-modal').modal('show');
    });
});
</script>

