<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Model\BaseDatabaseModel;

JLoader::register('LicenzerApiHelper', JPATH_ADMINISTRATOR . '/components/com_licenzer/helpers/api.php');

/**
 * Discount licenses model.
 */
class LicenzerModelDiscount extends BaseDatabaseModel
{
    /**
     * Get discount licenses
     */
    public function getDiscountLicenses()
    {
        $api = new LicenzerApiHelper();
        $licenses = $api->getDiscountLicenses();
        
        if (isset($licenses['status']) && $licenses['status'] == 'success') {
            return $licenses['data'] ?? array();
        }

        return array();
    }
}

