<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Factory;

/**
 * Licenses controller class.
 */
class LicenzerControllerLicenses extends BaseController
{
    /**
     * Method to display a view.
     */
    public function display($cachable = false, $urlparams = array())
    {
        $view = $this->getView('Licenses', 'html');
        $view->setModel($this->getModel('Licenses', 'LicenzerModel'), true);
        $view->display();
    }

    /**
     * Change IP address
     */
    public function changeIp()
    {
        // Check for request forgeries
        Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));

        $app = Factory::getApplication();
        $input = $app->input;

        $license_key = $input->getString('license_key');
        $new_ip = $input->getString('new_ip');
        $software_key = $input->getString('software_key');
        $current_ip = $input->getString('current_ip');

        if (empty($license_key) || empty($new_ip) || empty($software_key)) {
            $app->enqueueMessage(Text::_('COM_LICENZER_ERROR_MISSING_DATA'), 'error');
            $this->setRedirect('index.php?option=com_licenzer&view=licenses');
            return false;
        }

        if (!filter_var($new_ip, FILTER_VALIDATE_IP)) {
            $app->enqueueMessage(Text::_('COM_LICENZER_ERROR_INVALID_IP'), 'error');
            $this->setRedirect('index.php?option=com_licenzer&view=licenses');
            return false;
        }

        JLoader::register('LicenzerApiHelper', JPATH_ADMINISTRATOR . '/components/com_licenzer/helpers/api.php');
        $api = new LicenzerApiHelper();
        $result = $api->changeIp($current_ip, $new_ip, $software_key);

        if (isset($result['status']) && $result['status'] == 'success') {
            $app->enqueueMessage(Text::_('COM_LICENZER_IP_CHANGED_SUCCESS'), 'success');
        } else {
            $app->enqueueMessage($result['message'] ?? Text::_('COM_LICENZER_IP_CHANGE_FAILED'), 'error');
        }

        $this->setRedirect('index.php?option=com_licenzer&view=licenses');
    }
}

